local super = require "NumberFormatter"

CoefficientFormatter = super:new()

local defaults = {
    decimals = 1,
    groupings = true,
    symbol = '',
    value = 1,
}

local nilDefaults = {
}

function CoefficientFormatter:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    return self
end

function CoefficientFormatter:getFormatter()
    return NumberStringFormatter:coefficient()
end

function CoefficientFormatter:getArguments()
    return {
        self:getProperty('symbol'),
        self:getProperty('value'),
        self:getProperty('decimals'),
        1,
        self:getProperty('groupings'),
    }
end

function CoefficientFormatter:getInspectors()
    local list = List:new()
    local inspector, hook
    inspector = Inspector:new{
        type = 'Decimal',
    }
    inspector:addHook(self:getPropertyHook('decimals'), 'decimals')
    inspector:addHook(self:getPropertyHook('groupings'), 'groupings')
    list:add(inspector)
    inspector = self:createInspector('string-short', {'symbol'}, 'Unit')
    list:add(inspector)
    inspector = self:createInspector('number', {'value'}, 'Value')
    list:add(inspector)
    return list
end

return CoefficientFormatter
